

/* TODO
 
 Cleanup mark class
 
 Fork / Split the project eventually?
 
 Mechincally move left/right/up/down to next mark - experiment with diagonals.
 
 rotate marks in 90 degree orientations if necessary
 
 *sequencing options*
 
 Use this bounding box to have points touch the edges of
 the screen by picking points that are on the end of the box.
 
 Use marks to influence other marks / parent / child relationships
 
 Have a hard drive that organizes and archives all the marks - include pressure in the mark making format if necessary.
 
 // add eraser / automatic?
 
 */

//import java.util.Arrays;
import java.awt.Polygon;
import processing.opengl.*;
//import codeanticode.glgraphics.*;

mark currentMark;
mark playingMark;
mark[] marks;

int currentMarkIndex = 0;
int timer = 0;  

PVector lastMouse;
PVector markEnd;

int currentMarkFolder;
boolean editor = true;

// add read marks

void setup() {
  // size(screenWidth, screenHeight, JAVA2D);
  //size(800, 600);
  size(1080, 1920, OPENGL);
  //size(1920, 1080, JAVA2D);
  //size(1920, 1080, GLConstants.GLGRAPHICS);
  hint(DISABLE_OPENGL_2X_SMOOTH);
  frameRate(60);
  noCursor();
  fill(255);
  stroke(255);
  strokeWeight(1);
  //cursor(CROSS);
  marks = new mark[0];
  markEnd = new PVector(width/2, height/2);
  background(0);

  getMarkFolders();
  switchMarkFolder();
}

void addBasicMarks() {

  mark m;

  m = new mark();
  m.points = (int[][]) append(m.points, new int[] {
    0, 0, 0
  }
  ); 
  m.points = (int[][]) append(m.points, new int[] {
    1, 0, 0
  }
  );
  m.createPolygon();
  marks = (mark[]) append(marks, m);

  m = new mark();
  m.points = (int[][]) append(m.points, new int[] {
    0, 0, 0
  }
  ); 
  m.points = (int[][]) append(m.points, new int[] {
    0, 1, 0
  }
  );
  m.createPolygon();
  marks = (mark[]) append(marks, m);

  m = new mark();
  m.points = (int[][]) append(m.points, new int[] {
    0, 0, 0
  }
  ); 
  m.points = (int[][]) append(m.points, new int[] {
    -1, 0, 0
  }
  );
  m.createPolygon();
  marks = (mark[]) append(marks, m);

  m = new mark();
  m.points = (int[][]) append(m.points, new int[] {
    0, 0, 0
  }
  ); 
  m.points = (int[][]) append(m.points, new int[] {
    0, -1, 0
  }
  );
  m.createPolygon();
  marks = (mark[]) append(marks, m);
}

void draw() {

  background(0);

  if (editor) point(mouseX, mouseY);

  if (playingMark != null) {
    playingMark.render();
  }

  if (currentMark != null && currentMark.record) {
    currentMark.record();
  }

  timer++;

  if (timer == 3000) {
    switchMarkFolder();
    timer = 0;
  }
}

void keyPressed() {
  switch(key) {

  case 'e':
    editor = !editor;
    break;

  case ' ':
    switchMarkFolder();
    background(0);
    break;

  case 'x':
    stroke(255);
    break;

  case 'z':
    stroke(0);
    break;

  case 'q':
    noCursor();
    break;
  }
}

void mousePressed() {
  lastMouse = new PVector(mouseX, mouseY);
  playingMark = null; // dronegraph
  //marks = new mark[0];
  mark m = new mark();
  if (currentMark != null) {
    //markEnd.x = currentMark.x;
    //markEnd.y = currentMark.y;
  }
  currentMark = m;
  currentMark.record=true;
}

void mouseDragged() {
  line(pmouseX, pmouseY, mouseX, mouseY);
}

void mouseReleased() {
  currentMark.record=false;

  //markEnd.x = lastMouse.x + currentMark.points[currentMark.points.length-1][0];
  //markEnd.y = lastMouse.y + currentMark.points[currentMark.points.length-1][1];

  if (currentMark.points.length <= 1) return;
  marks = (mark[]) append(marks, currentMark);
  //currentMark.createPolygon();

  String directoriesName = String.valueOf(year()) + "/" + nf(month(), 2) + "-" + nf(day(), 2);
  String fileName = nf(hour(), 2) + "-" + nf(minute(), 2) + "-" + nf(second(), 2);
  currentMark.saveMark("marks/" + directoriesName + "/" + fileName);
  if (playingMark == null) playingMark = currentMark;
}

// loading



void switchMarkFolder() {
  ArrayList<File> markFolders = filesToArrayList();
  currentMarkFolder = int(random(markFolders.size() - 1));
  if (currentMarkFolder == markFolders.size()) currentMarkFolder = 0;
  marks = new mark[0];
  loadMarksFromFolder(markFolders.get(currentMarkFolder));
  addBasicMarks();
}

void getMarkFolders() {
  ArrayList<File> markFolders = filesToArrayList();
  currentMarkFolder = 0;
  marks = new mark[0];
  if (loadMarksFromFolder(markFolders.get(0))) playingMark = marks[0];
  addBasicMarks();
}

boolean loadMarksFromFolder(File folder) {
  File[] markFiles = folder.listFiles(txtFilter);
  if (markFiles.length > 0) {
    for (File mF : markFiles) {
      marks = (mark[]) append(marks, loadMarkFromFile(createReader(mF.getPath()), new mark()));
    }
  } 
  else return false;
  return true;
}

mark loadMarkFromFile(BufferedReader reader, mark m) {

  String line;

  try {
    line = reader.readLine();
  } 
  catch (IOException e) {
    e.printStackTrace();
    line = null;
  }
  if (line == null) {
    m.createPolygon();
    return m;
  } 
  else {
    String[] vertices = split(line, ",");
    int[] point = new int[0];
    point = append(point, int(vertices[0]));
    point = append(point, int(vertices[1]));
    if (vertices.length == 3) {
      point = append(point, int(vertices[2]));
    } 
    else {
      point = append(point, 0);
    };
    m.points = (int[][]) append(m.points, point);
    return loadMarkFromFile(reader, m);
  }
}

ArrayList filesToArrayList() {
  ArrayList<File> filesList = new ArrayList<File>();
  String folderPath = sketchPath("marks/2013/");
  if (folderPath != null) {
    File file = new File(folderPath);
    File[] files = file.listFiles(directoryFilter);
    for (int i = 0; i < files.length; i++) {
      filesList.add(files[i]);
    }
  }
  return(filesList);
}

FileFilter directoryFilter = new FileFilter() {
  public boolean accept(File file) {
    return file.isDirectory();
  }
};

FilenameFilter txtFilter = new FilenameFilter() { 
  public boolean accept(File dir, String filename)
  { 
    return filename.endsWith(".txt");
  }
}; 


